package com.bytesbee.mysinglelivechannel.activities;

import android.app.Application;

import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.managers.SessionManager;
import com.bytesbee.mysinglelivechannel.utils.ApplicationLifecycleManager;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.style.MIUIStyle;

public class UIApplication extends Application {

    @SuppressWarnings("deprecation")
    @Override
    public void onCreate() {
        super.onCreate();
        SessionManager.init(this);
        registerActivityLifecycleCallbacks(new ApplicationLifecycleManager());
        DialogX.init(this);
        DialogX.DEBUGMODE = false;
        DialogX.globalStyle = MIUIStyle.style();
        DialogX.globalTheme = DialogX.THEME.AUTO;
        DialogX.globalFontFamily = R.font.poppins_regular;
        DialogX.useActivityLayoutTranslationNavigationBar = true;
    }
}
